/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.emi;

import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.integration.modules.emi.AppEngRecipeCategory;
import appeng.integration.modules.emi.EmiText;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;

class EmiInscriberRecipe
extends BasicEmiRecipe {
    public static final EmiRecipeCategory CATEGORY = new AppEngRecipeCategory("inscriber", (EmiRenderable)EmiStack.of(AEBlocks.INSCRIBER), EmiText.CATEGORY_INSCRIBER);
    private final InscriberRecipe recipe;

    public EmiInscriberRecipe(InscriberRecipe recipe) {
        super(CATEGORY, recipe.method_8114(), 97, 64);
        this.recipe = recipe;
        if (!recipe.getTopOptional().method_8103()) {
            EmiIngredient top = EmiIngredient.of((class_1856)recipe.getTopOptional());
            if (recipe.getProcessType() == InscriberProcessType.INSCRIBE) {
                top.getEmiStacks().forEach(s -> s.setRemainder(s));
            }
            this.inputs.add(top);
        }
        if (!recipe.getBottomOptional().method_8103()) {
            EmiIngredient bottom = EmiIngredient.of((class_1856)recipe.getBottomOptional());
            if (recipe.getProcessType() == InscriberProcessType.INSCRIBE) {
                bottom.getEmiStacks().forEach(s -> s.setRemainder(s));
            }
            this.inputs.add(bottom);
        }
        this.inputs.add(EmiIngredient.of((class_1856)recipe.getMiddleInput()));
        this.outputs.add(EmiStack.of((class_1799)recipe.getResultItem()));
    }

    public void addWidgets(WidgetHolder widgets) {
        class_2960 background = AppEng.makeId("textures/guis/inscriber.png");
        widgets.addTexture(background, 0, 0, 97, 64, 44, 15);
        widgets.addAnimatedTexture(background, 91, 24, 6, 18, 135, 177, 2000, false, true, false);
        widgets.addSlot(EmiIngredient.of((class_1856)this.recipe.getTopOptional()), 0, 0).drawBack(false);
        widgets.addSlot(EmiIngredient.of((class_1856)this.recipe.getMiddleInput()), 18, 23).drawBack(false);
        widgets.addSlot(EmiIngredient.of((class_1856)this.recipe.getBottomOptional()), 0, 46).drawBack(false);
        widgets.addSlot((EmiIngredient)EmiStack.of((class_1799)this.recipe.getResultItem()), 68, 24).recipeContext((EmiRecipe)this).drawBack(false);
    }
}

